'use strict';

/**
 * SocketConnector class.
 *  Base class for all socket based connectors
 *
 * @constructor
 * @param {Object} socket - scoketio socket.
 */


var SocketConnector = function(socket) {
    this.socket = socket;
    this.verbose = false;
    this.verbose_name = "SocketConnector:";
    this.emit_name = "frontendRpc";
    this.controller_id = null;
    this.__call = this.__callSocketRpc;
    this.proceed_errors = true;


    this.SORT_DESC = 3;
    this.SORT_ASC = 4;
};

SocketConnector.prototype.__log = function() {
    if(this.verbose)
        console.log.bind(console).apply(null,arguments);
    // bind нужен для старого хрома http://qaru.site/questions/622200/why-i-cant-pass-consolelog-as-a-callback-argument-in-chrome-and-safari
};

SocketConnector.prototype.__callSocketRpc = function(method, params, cb ) {
    var _self = this;
    this.__log(this.verbose_name,"emmit", method, params);
    this.socket.emit( this.emit_name , {
        controller_id: this.controller_id,
        method: method,
        params: params
    }, function(e,r) {
        _self.__emmitCallback(e,r,cb,method)
    });
};

SocketConnector.prototype.__emmitCallback = function( err, result , cb, method ) {
    if(!this.__onResult( err, result , method))
        return;

    if(cb)
        cb(err,result);
};

SocketConnector.prototype.__onResult = function(err,result,method) {
    if (method === undefined)
        method = "";

    if(err) {
        return this.__onError(err, method);
    }

    this.__log(this.verbose_name,"result ("+method+")", result);

    return true;
};


SocketConnector.prototype.__onError = function(err, method) {
    if (method === undefined)
        method = "";

    this.__log(this.verbose_name,"error ("+method+")", err);
    return this.proceed_errors;
};
