'use strict';

/**
 * TournamentConnector class.
 *
 * About classes  https://learn.javascript.ru/class-inheritance
 * @inheritDoc
 */

function TournamentConnector(socket) {
    SocketConnector.apply(this, arguments);
    // SocketConnector.call(this, socket);
    this.verbose_name = "TournamentConnector:";
    this.controller_id = "tournament-rpc";

    this.STATUS_NONE               = 0;
    this.STATUS_ANNOUNCED          = 10;
    this.STATUS_OPEN               = 20;
    this.STATUS_IN_PLAY            = 30;
    this.STATUS_FINISHED           = 40;
    this.STATUS_CANCELED           = 50;

    this.PLAYERS_COUNT_MIN = 2;
    this.PLAYERS_COUNT_MAX = 64;

    this.my_uuid = null;
    var self = this;
    this.cb_state_changed = function(data) {self.__log("cb_tournament_changed", data); };
    //this.cb_my_tornament_started = function(data)   {self.__log("cb_my_tornament_started", data); };
    //this.cb_my_game_canceled = function(data)  {self.__log("cb_my_game_canceled", data);};
    //this.cb_revenge_request = function(data)   {self.__log("cb_revenge_request", data);};

    this.__setupCallbacks();
}

TournamentConnector.prototype = Object.create(SocketConnector.prototype);
TournamentConnector.prototype.constructor = TournamentConnector;

///**
// * Set current player_uuid
// *  call this method when you find_out uuid
// * @param player_uuid
// */
//GameConnector.prototype.setMyUuid = function(player_uuid) {
//    this.my_uuid = player_uuid;
//};

TournamentConnector.prototype.__setupCallbacks = function() {
    var self = this;

    this.socket.on("user_info", function(data) {
        self.my_uuid   = data.uuid;
    });

    this.socket.on("tournamentChanged", function(data) {
        self.__log("tournamentChanged", data);
        self.cb_state_changed(data);
    });
};


/**
 * join tournament
 * @param uuid uuid of tournament
 * @param cb function
 */
TournamentConnector.prototype.doJoin = function(uuid,cb) {
    this.__call("join", {
        uuid: uuid
    } , cb);
};

/**
 * view details
 * @param uuid uuid of tournament
 * @param cb function
 */
TournamentConnector.prototype.doView = function(uuid,cb) {
    this.__call("view", {
        uuid: uuid
    }, cb);
};


/**
 * Get list of tournaments
 *
 * @param search
 * @param search.status  int
 * @param pagination
 * @param pagination.page   int
 * @param pagination.pageSize  int
 * @param cb function
 */
TournamentConnector.prototype.doGetListSearch = function(search, pagination,cb) {
    this.__call("list", {
        pagination: pagination,
        search: search
    }, cb);
};


/**
 * Get list of tournaments
 *
 * @param search
 * @param search.status  int
 * @param pagination
 * @param pagination.page   int
 * @param pagination.pageSize  int
 * @param cb function
 */
TournamentConnector.prototype.doGetListHistory = function(search, pagination,cb) {
    this.__call("history", {
        pagination: pagination,
        search: search
    }, cb);
};


/**
 * Get time till next tournament or tour
 *
 * @param cb function
 * returns
 *      "meta": {
 *         "timestamp": integer
  *      }
 *      "time" => {
 *        "tournament_start":integer
 *        "tour_end": integer
 *      }
 *
 */
TournamentConnector.prototype.doGetTimeLeft = function(cb) {
    this.__call("get-time-left", {}, cb);
};




/**
 * callback when game list changed.
 * @param cb
 */
TournamentConnector.prototype.setCallbackTournamentChanged = function(cb) {
    this.__log("setCallbackTournamentChanged");
    this.cb_state_changed = cb;
};




